/* - TemperatureSensor full -
 * This example displays the connected Phidget TemperatureSensor device's 
 * details as well as the current sensor readings being generated by the 
 * thermocouple.  This example also demonstrates the ability to modify the 
 * sensor's sensitivity by setting it to a new double value in the provided 
 * textbox.
 * 
 * Please note that this example was designed to work with only one Phidget 
 * TemperatureSensor connected.
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package TemperatureSensor;

import com.phidgets.TemperatureSensorPhidget;
import com.phidgets.PhidgetException;

import javax.swing.JOptionPane;

import listeners.*;

public class TemperatureSensor extends javax.swing.JFrame {
    
    private static String runArgs[];
    private TemperatureSensorPhidget tempSensor;
    private TempSensorAttachListener attach_listener;
    private TempSensorDetachListener detach_listener;
    private TempSensorErrorListener error_listener;
    private TempSensorTemperatureChangeListener change_listener;
    
    /** Creates new form TemperatureSensor */
    public TemperatureSensor() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        numTCTxt = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        tcTempTxt = new javax.swing.JTextField();
        potTxt = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        sensitivityTxt = new javax.swing.JTextField();
        sensitivityScrl = new javax.swing.JSlider();
        onBoardTxt = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        thermoRngLbl = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        thermoTypeCmb = new javax.swing.JComboBox();
        potentialRngLbl = new javax.swing.JLabel();
        ambientRngLbl = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("TemperatureSensor - full");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Device Info"));

        attachedTxt.setEditable(false);

        jLabel1.setText("Attached:");

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        jScrollPane1.setViewportView(nameTxt);

        jLabel2.setText("Name:");

        serialTxt.setEditable(false);

        jLabel3.setText("Serial No.:");

        versionTxt.setEditable(false);

        jLabel4.setText("Version:");

        numTCTxt.setEditable(false);

        jLabel5.setText("Thermocouples:");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(31, 31, 31)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jLabel2)
                    .add(jLabel1)
                    .add(jLabel3)
                    .add(jLabel4)
                    .add(jLabel5))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, numTCTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, versionTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, serialTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, attachedTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(27, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(attachedTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel1))
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(15, 15, 15)
                        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(16, 16, 16)
                        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(serialTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabel3))
                        .add(16, 16, 16)
                        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(versionTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabel4))
                        .add(15, 15, 15)
                        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(numTCTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabel5)))
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(31, 31, 31)
                        .add(jLabel2)))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Sensor Data"));

        jLabel6.setText("Thermocouple Temperature:");

        tcTempTxt.setEditable(false);

        potTxt.setEditable(false);

        jLabel7.setText("Potential(milliVolts):");

        jLabel8.setText("Sensitivity:");

        sensitivityTxt.setEditable(false);

        sensitivityScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                sensitivityScrlStateChanged(evt);
            }
        });

        onBoardTxt.setEditable(false);

        jLabel9.setText("Ambient Temperature:");

        thermoRngLbl.setText("()");

        jLabel10.setText("Thermocouple Type:");

        thermoTypeCmb.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "K-Type", "J-Type", "E-Type", "T-Type" }));
        thermoTypeCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                thermoTypeCmbActionPerformed(evt);
            }
        });

        potentialRngLbl.setText("()");

        ambientRngLbl.setText("()");

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(jPanel2Layout.createSequentialGroup()
                                        .addContainerGap()
                                        .add(jLabel10))
                                    .add(jPanel2Layout.createSequentialGroup()
                                        .addContainerGap()
                                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                            .add(jPanel2Layout.createSequentialGroup()
                                                .add(10, 10, 10)
                                                .add(thermoRngLbl))
                                            .add(jLabel6))))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED))
                            .add(jPanel2Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(jLabel8)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(sensitivityTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 51, Short.MAX_VALUE)
                                .add(32, 32, 32))
                            .add(jPanel2Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(jPanel2Layout.createSequentialGroup()
                                        .add(10, 10, 10)
                                        .add(potentialRngLbl))
                                    .add(jLabel7))
                                .add(47, 47, 47)))
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(potTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, sensitivityScrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, thermoTypeCmb, 0, 142, Short.MAX_VALUE)
                            .add(tcTempTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE)))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(10, 10, 10)
                                .add(ambientRngLbl))
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(jLabel9)
                                .add(32, 32, 32)
                                .add(onBoardTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE)))))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel6)
                    .add(tcTempTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(thermoRngLbl)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel10)
                    .add(thermoTypeCmb, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel7)
                    .add(potTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(potentialRngLbl)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel9)
                    .add(onBoardTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(ambientRngLbl)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 13, Short.MAX_VALUE)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(jLabel8)
                        .add(sensitivityTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(sensitivityScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Initialize our temperatureSensor object and hook the event listeners
     **/
    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        sensitivityScrl.setEnabled(false);
        sensitivityScrl.setMaximum(200);
        sensitivityScrl.setMinimum(0);
        
        thermoTypeCmb.setEnabled(false);
        
        try
        {
            tempSensor = new TemperatureSensorPhidget();
            
            attach_listener = new TempSensorAttachListener(this, this.attachedTxt,
                    this.nameTxt, this.serialTxt, this.versionTxt, this.numTCTxt,
                    this.sensitivityScrl, this.potTxt, this.potentialRngLbl, 
                    this.tcTempTxt, this.thermoRngLbl, this.sensitivityTxt, 
                    this.onBoardTxt, this.ambientRngLbl, this.thermoTypeCmb);
            
            detach_listener = new TempSensorDetachListener(this, this.attachedTxt,
                    this.nameTxt, this.serialTxt, this.versionTxt, this.numTCTxt,
                    this.sensitivityScrl, this.potTxt, this.potentialRngLbl, 
                    this.tcTempTxt, this.thermoRngLbl, this.sensitivityTxt, 
                    this.onBoardTxt, this.ambientRngLbl, this.thermoTypeCmb);
            
            error_listener = new TempSensorErrorListener(this);
            
            change_listener = new TempSensorTemperatureChangeListener(this,
                    this.potTxt, this.tcTempTxt, this.onBoardTxt);
            
            tempSensor.addAttachListener(attach_listener);
            tempSensor.addDetachListener(detach_listener);
            tempSensor.addErrorListener(error_listener);
            tempSensor.addTemperatureChangeListener(change_listener);
            
            //This assumes that if there is a command line argument, it is a serial number
            //and we try to open that specific device. Otherwise, open any device.
            if((runArgs.length > 1) && (runArgs[1].equals("remote")))
            {
                tempSensor.open(Integer.parseInt(runArgs[0]), null);
            }
            else if(runArgs.length > 0)
            {
                tempSensor.open(Integer.parseInt(runArgs[0]));
            }
            else
            {
                tempSensor.openAny();
            }
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_formWindowOpened

    /**
     * When a new double valu is entered into the textbox, we will update the 
     * sensitivity value in the sensor. If no temperature sensor is attached 
     * when we try to update the sensitivity value, it will throw a 
     * PhidgetException, so we will catch it and deal with it accordingly
     **/
    private void sensitivityScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_sensitivityScrlStateChanged
        if(sensitivityScrl.isEnabled())
        {
            try
            {
                tempSensor.setTemperatureChangeTrigger(0, ((double)sensitivityScrl.getValue())/100.0); //thermocouple
                sensitivityTxt.setText(Double.toString(((double)sensitivityScrl.getValue())/100.0));
            }
            catch (PhidgetException ex)
            {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_sensitivityScrlStateChanged

    /**
     * When the application is terminating, close the Phidget.
     **/
    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        try
        {
            //unhook the event listeners
            tempSensor.removeTemperatureChangeListener(change_listener);
            tempSensor.removeErrorListener(error_listener);
            tempSensor.removeDetachListener(detach_listener);
            tempSensor.removeAttachListener(attach_listener);
            
            //close the temperaturesensor
            tempSensor.close();
            
            tempSensor = null;
            
            dispose();
            System.exit(0);
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
    }//GEN-LAST:event_formWindowClosed

    private void thermoTypeCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_thermoTypeCmbActionPerformed
        try
        {
            if(thermoTypeCmb.getSelectedItem().equals("K-Type"))
            {
                tempSensor.setThermocoupleType(0, TemperatureSensorPhidget.PHIDGET_TEMPERATURE_SENSOR_K_TYPE);
            }
            else if(thermoTypeCmb.getSelectedItem().equals("J-Type"))
            {
                tempSensor.setThermocoupleType(0, TemperatureSensorPhidget.PHIDGET_TEMPERATURE_SENSOR_J_TYPE);
            }
            else if(thermoTypeCmb.getSelectedItem().equals("E-Type"))
            {
                tempSensor.setThermocoupleType(0, TemperatureSensorPhidget.PHIDGET_TEMPERATURE_SENSOR_E_TYPE);
            }
            else if(thermoTypeCmb.getSelectedItem().equals("T-Type"))
            {
                tempSensor.setThermocoupleType(0, TemperatureSensorPhidget.PHIDGET_TEMPERATURE_SENSOR_T_TYPE);
            }
            
            thermoRngLbl.setText("(" + tempSensor.getTemperatureMin(0) + "C - " + tempSensor.getTemperatureMax(0) + "C)");
        }
        catch(PhidgetException ex)
        {
            thermoTypeCmb.setEnabled(false);
        }
    }//GEN-LAST:event_thermoTypeCmbActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new TemperatureSensor().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel ambientRngLbl;
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextField numTCTxt;
    private javax.swing.JTextField onBoardTxt;
    private javax.swing.JTextField potTxt;
    private javax.swing.JLabel potentialRngLbl;
    private javax.swing.JSlider sensitivityScrl;
    private javax.swing.JTextField sensitivityTxt;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JTextField tcTempTxt;
    private javax.swing.JLabel thermoRngLbl;
    private javax.swing.JComboBox thermoTypeCmb;
    private javax.swing.JTextField versionTxt;
    // End of variables declaration//GEN-END:variables
    
}
